/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRDebug;
import oracle.jvm.hotspot.jfr.JFRGlobalBuffer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class GlobalTraceBuffer
extends VMObject {
    private static AddressField bufField;
    private static AddressField nextField;
    private static JFRGlobalBuffer buffer;
    private static Address next;

    public GlobalTraceBuffer(Address addr) {
        super(addr);
        buffer = (JFRGlobalBuffer)VMObjectFactory.newObject(JFRGlobalBuffer.class, bufField.getValue(addr));
        next = nextField.getValue(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("GlobalTraceBuffer");
        bufField = type.getAddressField("_buf");
        nextField = type.getAddressField("_next");
    }

    public JFRGlobalBuffer getBuffer() {
        return buffer;
    }

    public GlobalTraceBuffer getNextGlobalTraceBuffer() {
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("GlobalTraceBuffer.getNextGlobalTraceBuffer(): next buffer pointer = " + next);
        }
        if (next != null) {
            return (GlobalTraceBuffer)VMObjectFactory.newObject(GlobalTraceBuffer.class, next);
        }
        return null;
    }

    public int write(JFRStreamWriter sw) {
        JFRGlobalBuffer buf = this.getBuffer();
        int size = (int)buf.usedSize();
        if (size == 0) {
            return 0;
        }
        sw.write(buf.getBytesAtStart());
        return size;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                GlobalTraceBuffer.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

