/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.g1.G1Allocator;
import sun.jvm.hotspot.gc_implementation.g1.G1MonitoringSupport;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegion;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegionManager;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegionSetBase;
import sun.jvm.hotspot.gc_interface.CollectedHeapName;
import sun.jvm.hotspot.memory.SharedHeap;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class G1CollectedHeap
extends SharedHeap {
    private static long hrmFieldOffset;
    private static long g1ReservedFieldOffset;
    private static AddressField g1Allocator;
    private static AddressField g1mmField;
    private static long oldSetFieldOffset;
    private static long humongousSetFieldOffset;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("G1CollectedHeap");
        hrmFieldOffset = type.getField("_hrm").getOffset();
        g1Allocator = type.getAddressField("_allocator");
        g1mmField = type.getAddressField("_g1mm");
        oldSetFieldOffset = type.getField("_old_set").getOffset();
        humongousSetFieldOffset = type.getField("_humongous_set").getOffset();
    }

    @Override
    public long capacity() {
        return this.hrm().capacity();
    }

    @Override
    public long used() {
        return this.allocator().getSummaryBytes();
    }

    public long n_regions() {
        return this.hrm().length();
    }

    private HeapRegionManager hrm() {
        Address hrmAddr = this.addr.addOffsetTo(hrmFieldOffset);
        return (HeapRegionManager)VMObjectFactory.newObject(HeapRegionManager.class, hrmAddr);
    }

    public G1MonitoringSupport g1mm() {
        Address g1mmAddr = g1mmField.getValue(this.addr);
        return (G1MonitoringSupport)VMObjectFactory.newObject(G1MonitoringSupport.class, g1mmAddr);
    }

    public G1Allocator allocator() {
        Address g1AllocatorAddr = g1Allocator.getValue(this.addr);
        return (G1Allocator)VMObjectFactory.newObject(G1Allocator.class, g1AllocatorAddr);
    }

    public HeapRegionSetBase oldSet() {
        Address oldSetAddr = this.addr.addOffsetTo(oldSetFieldOffset);
        return (HeapRegionSetBase)VMObjectFactory.newObject(HeapRegionSetBase.class, oldSetAddr);
    }

    public HeapRegionSetBase humongousSet() {
        Address humongousSetAddr = this.addr.addOffsetTo(humongousSetFieldOffset);
        return (HeapRegionSetBase)VMObjectFactory.newObject(HeapRegionSetBase.class, humongousSetAddr);
    }

    private Iterator<HeapRegion> heapRegionIterator() {
        return this.hrm().heapRegionIterator();
    }

    public void heapRegionIterate(SpaceClosure scl) {
        Iterator<HeapRegion> iter = this.heapRegionIterator();
        while (iter.hasNext()) {
            HeapRegion hr = iter.next();
            scl.doSpace(hr);
        }
    }

    @Override
    public CollectedHeapName kind() {
        return CollectedHeapName.G1_COLLECTED_HEAP;
    }

    public G1CollectedHeap(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                G1CollectedHeap.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

