/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.dial;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.ui.misc.ColorConstants;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.List;

public final class DialDescriptorRepository {
    private static final double DEFAULT_GRADIENT_START_VALUE = Double.NEGATIVE_INFINITY;
    private static final double DEFAULT_GRADIENT_END_VALUE = Double.POSITIVE_INFINITY;
    private static final String DIAL_DESCRIPTORS = "dialDescriptors";
    private static final String DIAL_DESCRIPTOR_REPOSITORY = "dialDescriptorRepository";
    private static final String GRADIENT_BEGIN_COLOR = "gradientBeginColor";
    private static final String GRADIENT_BEGIN_VALUE = "gradientBeginValue";
    private static final String GRADIENT_END_COLOR = "gradientEndColor";
    private static final String GRADIENT_END_VALUE = "gradientEndValue";
    private static final String UNIT = "unit";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String EVENT_TYPES = "eventTypes";
    private static final String ALLOW_OPERATIVE_SET = "allowOperativeSet";
    private final Setting m_settings = new Setting("dialDescriptorRepository");

    static {
        PersistenceToolkit.registerFetcher(DialDescriptorRepository.class, (ISettingFetcher)new ISettingFetcher<DialDescriptorRepository>(){

            public Setting getSetting(DialDescriptorRepository configuration) {
                return configuration.m_settings;
            }
        });
    }

    public DialDescriptorRepository() {
        this.setGradientBeginColor(ColorConstants.DIAL_GOOD_COLOR);
        this.setGradientEndColor(ColorConstants.DIAL_BAD_COLOR);
        this.setGradientBeginValue(Double.NEGATIVE_INFINITY);
        this.setGradientEndValue(Double.POSITIVE_INFINITY);
        this.setUnit(new UnitDescriptor());
    }

    public void setDescription(String description) {
        this.m_settings.setChildObject(DESCRIPTION, (Object)description);
    }

    public void setTitle(String title) {
        this.m_settings.setChildObject(TITLE, (Object)title);
    }

    public void setGradientEndValue(double value) {
        this.m_settings.setChildObject(GRADIENT_END_VALUE, (Object)value);
    }

    public void setGradientBeginValue(double value) {
        this.m_settings.setChildObject(GRADIENT_BEGIN_VALUE, (Object)value);
    }

    public void setGradientEndColor(MCColor color) {
        this.m_settings.setChildObject(GRADIENT_END_COLOR, (Object)color);
    }

    public void setGradientBeginColor(MCColor color) {
        this.m_settings.setChildObject(GRADIENT_BEGIN_COLOR, (Object)color);
    }

    public String getDescription() {
        return (String)this.m_settings.getChildObject(DESCRIPTION, String.class);
    }

    public String getTitle() {
        return (String)this.m_settings.getChildObject(TITLE, String.class);
    }

    public double getGradientEndValue() {
        return (Double)this.m_settings.getChildObject(GRADIENT_END_VALUE, Double.class);
    }

    public double getGradientBeginValue() {
        return (Double)this.m_settings.getChildObject(GRADIENT_BEGIN_VALUE, Double.class);
    }

    public MCColor getGradientEndColor() {
        return (MCColor)this.m_settings.getChildObject(GRADIENT_END_COLOR, MCColor.class);
    }

    public MCColor getGradientBeginColor() {
        return (MCColor)this.m_settings.getChildObject(GRADIENT_BEGIN_COLOR, MCColor.class);
    }

    public EventTypeDescriptorRepository getEventTypeDescriptorBase() {
        return (EventTypeDescriptorRepository)this.m_settings.getChildObject(EVENT_TYPES, EventTypeDescriptorRepository.class);
    }

    public List<DialDescriptor> getDialDescriptors() {
        return (List)this.m_settings.getChildObject(DIAL_DESCRIPTORS, new Type(List.class, new Type[]{new Type(DialDescriptor.class)}));
    }

    public UnitDescriptor getUnit() {
        return (UnitDescriptor)this.m_settings.getChildObject(UNIT, UnitDescriptor.class);
    }

    public void setUnit(UnitDescriptor unit) {
        this.m_settings.setChildObject(UNIT, (Object)unit);
    }

    public void setAllowOperativeSet(boolean operativeSet) {
        this.m_settings.setChildObject(ALLOW_OPERATIVE_SET, (Object)operativeSet);
    }

    public boolean getAllowOperariveSet() {
        return (Boolean)this.m_settings.getChildObject(ALLOW_OPERATIVE_SET, Boolean.class);
    }
}

