/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.RulerModel;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class RulerLine
implements PaintListener,
DisposeListener,
Observer {
    private final Color m_rulerColor;
    private final Composite m_parent;
    private final RulerModel m_rulerModel;

    public RulerLine(Composite parent, RulerModel model) {
        this.m_parent = parent;
        this.m_rulerModel = model;
        this.m_parent.addDisposeListener((DisposeListener)this);
        this.m_parent.addPaintListener((PaintListener)this);
        this.m_rulerColor = new Color((Device)parent.getDisplay(), GraphHelper.DEFAULT_FOREGROUND_COLOR.getRGBColor());
        this.m_rulerModel.addObserver(this);
    }

    public void paintControl(PaintEvent e) {
        if (this.m_rulerModel.isVisible() && this.m_rulerModel.getPosition() > this.m_rulerModel.getMinimumPosition() && e.x < this.m_rulerModel.getMaximumPosition()) {
            Rectangle rect = this.m_parent.getClientArea();
            e.gc.setLineStyle(1);
            e.gc.setForeground(this.m_rulerColor);
            e.gc.drawLine(this.m_rulerModel.getPosition(), rect.y, this.m_rulerModel.getPosition(), rect.y + rect.height);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.m_rulerColor != null && !this.m_rulerColor.isDisposed()) {
            this.m_rulerColor.dispose();
        }
        this.m_rulerModel.deleteObserver(this);
        this.m_parent.removePaintListener((PaintListener)this);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.m_parent.redraw();
    }
}

