/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.TrackSampler;
import com.jrockit.mc.flightrecorder.util.AlwaysTrueFilter;
import com.jrockit.mc.ui.misc.MCColor;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class UITrack
implements Visitable,
Comparable<UITrack>,
Iterable<IEvent> {
    private final RenderInfo m_renderInfo = new RenderInfo();
    private final ITimeRange m_range = ITimeRange.INFINITE_RANGE;
    private final IView m_view;
    private final String m_name;

    public UITrack(FlightRecording recording, List<ITrack> tracks, String name, Color c) {
        this.m_view = recording.createView();
        this.m_view.setTracks(tracks);
        this.m_name = String.valueOf(name);
        TrackSampler sampler = new TrackSampler();
        sampler.setInput(this.m_view);
        this.m_renderInfo.setSampler(sampler);
        this.m_renderInfo.setColor(this.createGreenShadedColor(Color.GREEN));
    }

    public MCColor createGreenShadedColor(Color color) {
        float[] greenHSB = Color.RGBtoHSB(0, 255, 0, null);
        Color newColor = new Color(Color.HSBtoRGB(greenHSB[0], 0.3f + 0.3f * ((float)color.getGreen() / 255.0f), 0.5f + 0.5f * ((float)color.getBlue() / 255.0f)));
        return new MCColor(newColor);
    }

    public String toString() {
        return this.m_name;
    }

    public RenderInfo getRenderInfo() {
        return this.m_renderInfo;
    }

    public MCColor getColor() {
        return new MCColor(Color.ORANGE);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public int compareTo(UITrack uthat) {
        return uthat.getName().compareTo(this.getName());
    }

    public ITimeRange getRange() {
        return this.m_range;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public Iterator<IEvent> iterator() {
        this.m_view.setRange(ITimeRange.INFINITE_RANGE);
        this.m_view.setFilter(AlwaysTrueFilter.getInstance());
        this.m_view.setExpansion(Expansion.NORMAL);
        return this.m_view.iterator();
    }

    public Iterator<IEvent> iterator(IEventFilter filter, ITimeRange range, Expansion rs) {
        this.m_view.setRange(range);
        this.m_view.setFilter(filter);
        this.m_view.setExpansion(rs);
        return this.m_view.iterator();
    }

    public Collection<ITrack> getTrackDescriptors() {
        return this.m_view.getTracks();
    }

    public int hashCode() {
        return this.m_name == null ? 0 : this.m_name.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

