/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.successors;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNodeTreeBuilder;
import java.util.List;
import java.util.ListIterator;

public class SuccessorFrameNodeBuilder
extends FrameNodeTreeBuilder {
    public SuccessorFrameNodeBuilder(FrameNode topNOde, FrameEqualityChecker frameEqualityChecker, GathererFactory gathererFactory) {
        super(topNOde, frameEqualityChecker, gathererFactory, IMCAggregatedFrame.AggregationType.SUCCESSORS);
    }

    @Override
    protected void addTrace(HistogramItem traceInformation) {
        FrameNode frameNode = this.getTopNode();
        IAggregator[] aggregators = traceInformation.getAggregators();
        Object object = traceInformation.getKey();
        FrameNode traceReference = null;
        if (object instanceof IMCStackTrace) {
            IMCStackTrace s = (IMCStackTrace)object;
            List frames = s.getFrames();
            ListIterator iterator = frames.listIterator(frames.size());
            while (iterator.hasPrevious()) {
                IMCFrame frame = (IMCFrame)iterator.previous();
                if (frame.equals(frameNode.getFrame())) {
                    traceReference = frameNode;
                    traceInformation.setUsed(true);
                }
                if (traceReference == null) continue;
                frameNode = this.nextFrameNode(traceInformation, frameNode, frame);
                frameNode.addAggregators(aggregators);
            }
        }
    }
}

