/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.range;

import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.range.ISynchronizable;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.Collection;

public final class RangeController {
    private static final String PROPERTY_NAVIGATOR_SYNCHRONIZATION = "navigator.synchronization";
    private final Object m_ignoree;
    private final UIScope m_UIScope;
    private ITimeRange m_range;

    public RangeController(UIScope scope, Object ignoree) {
        this(scope, ignoree, null);
    }

    public RangeController(UIScope scope, Object ignoree, ITimeRange range) {
        this.m_range = range;
        this.m_ignoree = ignoree;
        this.m_UIScope = scope;
    }

    public void onNavigatorChange(Object source, double minX, double maxX) {
        this.sendRangeChange((ITimeRange)new TimeRange((long)minX, (long)maxX), this.m_UIScope.getAllComponents(INavigatorSelectionChangeListener.class));
    }

    public void setUseSynchronization(boolean use) {
        FlightRecorderUI.getDefault().getPreferenceStore().setValue(PROPERTY_NAVIGATOR_SYNCHRONIZATION, use);
        if (use && this.m_range != null) {
            this.sendRangeChange(this.m_range, this.m_UIScope.getTopScope().getCompatiblesWithChildren(INavigatorSelectionChangeListener.class));
        }
        for (ISynchronizable s : this.getScope().getTopScope().getCompatiblesWithChildren(ISynchronizable.class)) {
            s.synchronizationChange();
        }
    }

    public static boolean getUseSynchronization() {
        return FlightRecorderUI.getDefault().getPreferenceStore().getBoolean(PROPERTY_NAVIGATOR_SYNCHRONIZATION);
    }

    public void setRange(ITimeRange range, boolean broadcast) {
        this.m_range = range;
        if (broadcast) {
            if (RangeController.getUseSynchronization()) {
                this.sendRangeChange(range, this.getScope().getTopScope().getCompatiblesWithChildren(INavigatorSelectionChangeListener.class));
            } else {
                this.sendRangeChange(range, this.getScope().getInAncestorAndChildrenScopes(INavigatorSelectionChangeListener.class));
            }
        }
    }

    private void sendRangeChange(ITimeRange range, Collection<INavigatorSelectionChangeListener> rangeListeners) {
        for (INavigatorSelectionChangeListener ircl : rangeListeners) {
            if (ircl == this.m_ignoree) continue;
            ircl.onChange(range.getStartTimestamp(), range.getEndTimestamp());
        }
    }

    private UIScope getScope() {
        return this.m_UIScope;
    }

    ITimeRange getRange() {
        return this.m_range;
    }
}

