/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    private static final int SSL_CERT_SAN_DNS_NAME = 2;
    public static final String[] VALID_SSL_VERSION_STRINGS = new String[]{"0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3", "1.1", "1.2", "1.1 or 3.0", "1.2 or 3.0", "1.1 or 1.0", "1.2 or 1.0", "1.2 or 1.1", "1.1 or 1.0 or 3.0", "1.2 or 1.0 or 3.0", "1.2 or 1.1 or 1.0", "1.2 or 1.1 or 3.0", "1.2 or 1.1 or 1.0 or 3.0"};
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1.2", "TLSv1.1", "TLSv1"}, {"SSLv2Hello"}, {"SSLv3"}, {"TLSv1"}, {"TLSv1", "SSLv3"}, {"TLSv1.1"}, {"TLSv1.2"}, {"TLSv1.1", "SSLv3"}, {"TLSv1.2", "SSLv3"}, {"TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1"}, {"TLSv1.2", "TLSv1.1"}, {"TLSv1.1", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1.1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"}};
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    static final HashSet<String> UNSUPPORTED_PROTOCOLS_SET = new HashSet();

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sSLSocket, SSLEngine sSLEngine, String string, boolean bl) throws NetException, IOException {
        if (string == null) {
            string = System.getProperty("oracle.net.ssl_version");
        }
        String[] stringArray = null;
        int n2 = 0;
        if (string != null) {
            string = string.startsWith("(") && string.endsWith(")") ? "(ssl_version=" + string.substring(1) : "(ssl_version=" + string + ")";
            try {
                NVPair nVPair = new NVFactory().createNVPair(string);
                String string2 = nVPair.getAtom();
                for (int i2 = 0; i2 < VALID_SSL_VERSION_STRINGS.length; ++i2) {
                    if (!string2.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i2])) continue;
                    n2 = i2;
                    break;
                }
            }
            catch (NLException nLException) {
                throw (NetException)new NetException(400, string).initCause(nLException);
            }
            if (n2 >= VALID_SSL_VERSION_STRINGS.length) {
                throw new NetException(400);
            }
            stringArray = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[n2]];
        } else {
            stringArray = TcpsConfigure.getAllSupportedProtocols(bl, sSLEngine, sSLSocket);
            if (stringArray == null) {
                throw new NetException(400);
            }
        }
        try {
            if (!bl) {
                sSLSocket.setEnabledProtocols(stringArray);
            } else {
                sSLEngine.setEnabledProtocols(stringArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (NetException)new NetException(401).initCause(illegalArgumentException);
        }
    }

    public static void configureCipherSuites(SSLSocket sSLSocket, SSLEngine sSLEngine, String string, boolean bl) throws NetException, IOException {
        if (string == null) {
            string = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (string == null) {
            return;
        }
        string = string.startsWith("(") && string.endsWith(")") ? "(cipher_suites=" + string + ")" : "(cipher_suites=(" + string + "))";
        try {
            NVPair nVPair = new NVFactory().createNVPair(string);
            String[] stringArray = new String[nVPair.getListSize()];
            if (nVPair.getRHSType() == NVPair.LIST_COMMASEP || nVPair.getRHSType() == NVPair.RHS_LIST) {
                for (int i2 = 0; i2 < nVPair.getListSize(); ++i2) {
                    stringArray[i2] = nVPair.getListElement(i2).getName();
                }
            } else {
                throw new NetException(403, string);
            }
            if (!bl) {
                sSLSocket.setEnabledCipherSuites(stringArray);
            } else {
                sSLEngine.setEnabledCipherSuites(stringArray);
            }
        }
        catch (NLException nLException) {
            throw new NetException(403, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (NetException)new NetException(404).initCause(illegalArgumentException);
        }
    }

    private static String[] getAllSupportedProtocols(boolean bl, SSLEngine sSLEngine, SSLSocket sSLSocket) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        stringArray = bl ? sSLEngine.getSupportedProtocols() : sSLSocket.getSupportedProtocols();
        if (stringArray == null) {
            return null;
        }
        for (String string : stringArray) {
            if (UNSUPPORTED_PROTOCOLS_SET.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv3");
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv2Hello");
    }
}

